package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNetworkSettings;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithNetworkSettingsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.rbac.RbacService;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_CONTEXT_LIMIT;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MIN_CONTEXT_LIMIT;
import static ru.yandex.direct.validation.defect.NumberDefects.inInterval;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNetworkSettingsAddValidationTypeSupport extends AbstractCampaignAddValidationTypeSupport<CampaignWithNetworkSettings> {
    private final RbacService rbacService;

    @Autowired
    public CampaignWithNetworkSettingsAddValidationTypeSupport(RbacService rbacService) {
        this.rbacService = rbacService;
    }

    @Override
    public Class<CampaignWithNetworkSettings> getTypeClass() {
        return CampaignWithNetworkSettings.class;
    }

    @Override
    public ValidationResult<List<CampaignWithNetworkSettings>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithNetworkSettings>, Defect> vr) {
        //0 не может быть входным параметром, но может быть проставлен самой операцией.
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> {
                    var vb = ModelItemValidationBuilder.of(campaign);
                    vb.item(CampaignWithNetworkSettings.CONTEXT_LIMIT)
                            .check(Constraint.fromPredicate(contextLimit -> contextLimit > 0,
                                    inInterval(MIN_CONTEXT_LIMIT, MAX_CONTEXT_LIMIT)));
                    return vb.getResult();
                })
                .getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithNetworkSettings>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithNetworkSettings>, Defect> vr) {
        CampaignWithNetworkSettingsValidator validator =
                new CampaignWithNetworkSettingsValidator(rbacService.getUidRole(container.getOperatorUid()));

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }

}
