package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNewIosVersion;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithNewIosVersionForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNewIosVersionAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithNewIosVersion> {

    private final FeatureService featureService;
    private final CampaignWithNewIosVersionForbiddenValidator<CampaignWithNewIosVersion> validator;

    public CampaignWithNewIosVersionAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
        this.validator = new CampaignWithNewIosVersionForbiddenValidator<>();
    }

    @Override
    public Class<CampaignWithNewIosVersion> getTypeClass() {
        return CampaignWithNewIosVersion.class;
    }

    @Override
    public ValidationResult<List<CampaignWithNewIosVersion>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithNewIosVersion>, Defect> vr
    ) {
        var isShowRmpOnNewIosVersionEnabled = featureService.isEnabledForClientId(
                container.getClientId(), FeatureName.SHOW_RMP_ON_NEW_IOS_VERSION_ENABLED
        );
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator, When.isFalse(isShowRmpOnNewIosVersionEnabled || container.isCopy()))
                .getResult();
    }
}
