package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithNewIosVersionForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithNewIosVersionForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithNewIosVersionForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithNewIosVersionForbidden> {

    private final CampaignWithNewIosVersionForbiddenValidator<CampaignWithNewIosVersionForbidden> validator;

    public CampaignWithNewIosVersionForbiddenAddValidationTypeSupport() {
        this.validator = new CampaignWithNewIosVersionForbiddenValidator<>();
    }

    @Override
    public Class<CampaignWithNewIosVersionForbidden> getTypeClass() {
        return CampaignWithNewIosVersionForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithNewIosVersionForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithNewIosVersionForbidden>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator, When.isFalse(container.isCopy()))
                .getResult();
    }
}
