package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOfflineStatNoticeEvent;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOfflineStatNoticeEventAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOfflineStatNoticeEvent> {
    @Override
    public Class<CampaignWithOfflineStatNoticeEvent> getTypeClass() {
        return CampaignWithOfflineStatNoticeEvent.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOfflineStatNoticeEvent>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOfflineStatNoticeEvent>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(VALIDATOR)
                .getResult();
    }

    private static final Validator<CampaignWithOfflineStatNoticeEvent, Defect> VALIDATOR = filter -> {
        ModelItemValidationBuilder<CampaignWithOfflineStatNoticeEvent> vb = ModelItemValidationBuilder.of(filter);
        vb.item(CampaignWithOfflineStatNoticeEvent.ENABLE_OFFLINE_STAT_NOTICE)
                .check(notNull());
        return vb.getResult();
    };
}
