package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddMetrikaTagToUrl;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalAddMetrikaTagToUrlValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalAddMetrikaTagToUrlAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalAddMetrikaTagToUrl> {

    @Override
    public Class<CampaignWithOptionalAddMetrikaTagToUrl> getTypeClass() {
        return CampaignWithOptionalAddMetrikaTagToUrl.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalAddMetrikaTagToUrl>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalAddMetrikaTagToUrl>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);
        vb.checkEachBy(campaign -> new CampaignWithOptionalAddMetrikaTagToUrlValidator().apply(campaign));
        return vb.getResult();
    }
}
