package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalAddOpenstatTagToUrl;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalAddOpenstatTagToUrlValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalAddOpenstatTagToUrlAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalAddOpenstatTagToUrl> {

    @Override
    public Class<CampaignWithOptionalAddOpenstatTagToUrl> getTypeClass() {
        return CampaignWithOptionalAddOpenstatTagToUrl.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalAddOpenstatTagToUrl>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalAddOpenstatTagToUrl>, Defect> vr) {

        var vb = new ListValidationBuilder<>(vr);
        vb.checkEachBy(campaign -> new CampaignWithOptionalAddOpenstatTagToUrlValidator().apply(campaign));
        return vb.getResult();
    }
}
