package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalHasTurboSmarts;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalHasTurboSmartsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalHasTurboSmartsAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalHasTurboSmarts> {

    private FeatureService featureService;

    @Autowired
    public CampaignWithOptionalHasTurboSmartsAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithOptionalHasTurboSmarts> getTypeClass() {
        return CampaignWithOptionalHasTurboSmarts.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalHasTurboSmarts>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalHasTurboSmarts>, Defect> vr) {
        boolean hasTurboSmarts = featureService
                .isEnabledForClientId(container.getClientId(), FeatureName.TURBO_SMARTS);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignWithOptionalHasTurboSmartsValidator(hasTurboSmarts)
                        .apply(campaign))
                .getResult();
    }
}
