package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalHasTurboSmartsForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalHasTurboSmartsForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalHasTurboSmartsForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalHasTurboSmartsForbidden> {
    @Override
    public Class<CampaignWithOptionalHasTurboSmartsForbidden> getTypeClass() {
        return CampaignWithOptionalHasTurboSmartsForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalHasTurboSmartsForbidden>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalHasTurboSmartsForbidden>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new CampaignWithOptionalHasTurboSmartsForbiddenValidator().apply(campaign))
                .getResult();
    }
}
