package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalMeaningfulGoalsValuesFromMetrika;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika> getTypeClass() {
        return CampaignWithOptionalMeaningfulGoalsValuesFromMetrika.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>, Defect> vr) {
        boolean featureIsEnabled = featureService
                .isEnabledForClientId(container.getClientId(),
                        FeatureName.AUTO_BUDGET_MEANINGFUL_GOALS_VALUES_FROM_METRIKA);

        var validator =
                new CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbiddenValidator<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>();

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator, When.isTrue(!container.isCopy() && !featureIsEnabled))
                .getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>, Defect> validate(CampaignValidationContainer container, ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrika>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaValidator(),
                        When.isFalse(container.isCopy()))
                .getResult();
    }
}
