package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden> {

    @Override
    public Class<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden> getTypeClass() {
        return CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(c -> new CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbiddenValidator
                                <CampaignWithOptionalMeaningfulGoalsValuesFromMetrikaForbidden>().apply(c))
                .getResult();
    }
}
