package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalRequireFiltrationByDontShowDomains;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalRequireFiltrationByDontShowDomainsValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalRequireFiltrationByDontShowDomainsAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalRequireFiltrationByDontShowDomains> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithOptionalRequireFiltrationByDontShowDomainsAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithOptionalRequireFiltrationByDontShowDomains> getTypeClass() {
        return CampaignWithOptionalRequireFiltrationByDontShowDomains.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalRequireFiltrationByDontShowDomains>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalRequireFiltrationByDontShowDomains>, Defect> vr) {

        boolean canRequireFiltrationByDontShowDomainsFeatureEnabled = featureService
                .isEnabledForClientId(container.getClientId(), FeatureName.CAN_REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS);
        boolean canRequireFiltrationByDontShowDomainsInCpmFeatureEnabled = featureService
                .isEnabledForClientId(container.getClientId(), FeatureName.CAN_REQUIRE_FILTRATION_BY_DONT_SHOW_DOMAINS_IN_CPM);

        var validator =
                new CampaignWithOptionalRequireFiltrationByDontShowDomainsValidator(
                        canRequireFiltrationByDontShowDomainsFeatureEnabled,
                        canRequireFiltrationByDontShowDomainsInCpmFeatureEnabled);

        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> validator.apply(campaign, false))
                .getResult();
    }
}
