package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOptionalS2sTracking;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOptionalS2sTrackingValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOptionalS2sTrackingAddValidationTypeSupport extends AbstractCampaignAddValidationTypeSupport<CampaignWithOptionalS2sTracking> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithOptionalS2sTrackingAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithOptionalS2sTracking> getTypeClass() {
        return CampaignWithOptionalS2sTracking.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOptionalS2sTracking>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOptionalS2sTracking>, Defect> vr) {
        var isS2sTrackingFeatureEnabled = featureService.isEnabledForClientId(container.getClientId(),
                FeatureName.IS_S2S_TRACKING_ENABLED);
        var validator = new CampaignWithOptionalS2sTrackingValidator(isS2sTrackingFeatureEnabled);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }
}
