package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrderPhraseLengthPrecedence;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOrderPhraseLengthPrecedenceForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrderPhraseLengthPrecedenceAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOrderPhraseLengthPrecedence> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithOrderPhraseLengthPrecedenceAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithOrderPhraseLengthPrecedence> getTypeClass() {
        return CampaignWithOrderPhraseLengthPrecedence.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOrderPhraseLengthPrecedence>, Defect> preValidate(
            CampaignValidationContainer container, ValidationResult<List<CampaignWithOrderPhraseLengthPrecedence>,
            Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);
        boolean isOrderPhraseLengthPrecedenceAllowed = featureService.isEnabledForClientId(container.getClientId(),
                FeatureName.IS_ORDER_PHRASE_LENGTH_PRECEDENCE_ALLOWED);
        vb.checkEachBy(c -> new CampaignWithOrderPhraseLengthPrecedenceForbiddenValidator
                        <CampaignWithOrderPhraseLengthPrecedence>().apply(c),
                When.isTrue(!container.isCopy() && !isOrderPhraseLengthPrecedenceAllowed));
        return vb.getResult();
    }
}
