package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrderPhraseLengthPrecedenceForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithOrderPhraseLengthPrecedenceForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrderPhraseLengthPrecedenceForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOrderPhraseLengthPrecedenceForbidden> {
    @Override
    public Class<CampaignWithOrderPhraseLengthPrecedenceForbidden> getTypeClass() {
        return CampaignWithOrderPhraseLengthPrecedenceForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOrderPhraseLengthPrecedenceForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOrderPhraseLengthPrecedenceForbidden>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(c -> new CampaignWithOrderPhraseLengthPrecedenceForbiddenValidator
                        <CampaignWithOrderPhraseLengthPrecedenceForbidden>().apply(c))
                .getResult();
    }
}
