package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithOrganizationAndPhone;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.clientphone.repository.ClientPhoneRepository;
import ru.yandex.direct.core.entity.trackingphone.model.ClientPhone;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.utils.FunctionalUtils.listToSet;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;
import static ru.yandex.direct.validation.defect.CommonDefects.objectNotFound;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithOrganizationAndPhoneAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithOrganizationAndPhone> {

    private final ClientPhoneRepository clientPhoneRepository;

    @Autowired
    public CampaignWithOrganizationAndPhoneAddValidationTypeSupport(ClientPhoneRepository clientPhoneRepository) {
        this.clientPhoneRepository = clientPhoneRepository;
    }

    @Override
    public Class<CampaignWithOrganizationAndPhone> getTypeClass() {
        return CampaignWithOrganizationAndPhone.class;
    }

    @Override
    public ValidationResult<List<CampaignWithOrganizationAndPhone>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOrganizationAndPhone>, Defect> vr) {

        Validator<CampaignWithOrganizationAndPhone, Defect> validator =
                campaign -> {
            ModelItemValidationBuilder<CampaignWithOrganizationAndPhone> vb = ModelItemValidationBuilder.of(campaign);
            vb.item(CampaignWithOrganizationAndPhone.DEFAULT_TRACKING_PHONE_ID)
                    .check(validId(), When.notNull());
            return vb.getResult();
        };

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator)
                .getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithOrganizationAndPhone>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithOrganizationAndPhone>, Defect> vr) {

        List<Long> permalinkIds = mapList(ValidationResult.getValidItems(vr),
                CampaignWithOrganizationAndPhone::getDefaultPermalinkId);

        if (permalinkIds.isEmpty()) {
            return vr;
        }

        Set<Long> clientPhones = listToSet(
                clientPhoneRepository.getAllClientPhones(container.getClientId(), permalinkIds),
                ClientPhone::getId);

        Validator<CampaignWithOrganizationAndPhone, Defect> validator = campaign -> {
            ModelItemValidationBuilder<CampaignWithOrganizationAndPhone> vb = ModelItemValidationBuilder.of(campaign);

            vb.item(CampaignWithOrganizationAndPhone.DEFAULT_TRACKING_PHONE_ID)
                    .check(fromPredicate(clientPhones::contains, objectNotFound()));

            return vb.getResult();
        };

        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator, When.isValid())
                .getResult();
    }
}
