package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithRecommendationsManagement;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithRecommendationsManagementPreValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithRecommendationsManagementAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithRecommendationsManagement> {
    private static final CampaignWithRecommendationsManagementPreValidator PRE_VALIDATOR =
            new CampaignWithRecommendationsManagementPreValidator();

    @Override
    public Class<CampaignWithRecommendationsManagement> getTypeClass() {
        return CampaignWithRecommendationsManagement.class;
    }

    @Override
    @SuppressWarnings("rawtypes")
    public ValidationResult<List<CampaignWithRecommendationsManagement>, Defect> preValidate(
            CampaignValidationContainer ignored,
            ValidationResult<List<CampaignWithRecommendationsManagement>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(PRE_VALIDATOR)
                .getResult();
    }
}
