package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSimplifiedStrategyViewForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithSimplifiedStrategyViewForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSimplifiedStrategyViewForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithSimplifiedStrategyViewForbidden> {

    @Override
    public Class<CampaignWithSimplifiedStrategyViewForbidden> getTypeClass() {
        return CampaignWithSimplifiedStrategyViewForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithSimplifiedStrategyViewForbidden>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithSimplifiedStrategyViewForbidden>, Defect> vr) {
        var vb = new ListValidationBuilder<>(vr);

        vb.checkEachBy(c -> new CampaignWithSimplifiedStrategyViewForbiddenValidator().apply(c));
        return vb.getResult();
    }

}
