package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSiteMonitoring;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithSiteMonitoringValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSiteMonitoringAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithSiteMonitoring> {
    @Override
    public Class<CampaignWithSiteMonitoring> getTypeClass() {
        return CampaignWithSiteMonitoring.class;
    }

    @Override
    public ValidationResult<List<CampaignWithSiteMonitoring>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithSiteMonitoring>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithSiteMonitoringValidator())
                .getResult();
    }

}
