package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;
import java.util.Optional;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSkadNetwork;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSkadNetworkAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithSkadNetwork> {

    private final FeatureService featureService;

    public CampaignWithSkadNetworkAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithSkadNetwork> getTypeClass() {
        return CampaignWithSkadNetwork.class;
    }

    private ValidationResult<CampaignWithSkadNetwork, Defect> validateCampaign(boolean featureEnabled,
                                                                               CampaignWithSkadNetwork campaign) {

        var vb = ModelItemValidationBuilder.<CampaignWithSkadNetwork, Defect>of(campaign);
        var skadNetworkEnabled = Optional.ofNullable(campaign.getIsSkadNetworkEnabled()).orElse(false);
        vb.check(fromPredicate(value -> featureEnabled || !skadNetworkEnabled, invalidValue()));

        return vb.getResult();
    }

    @Override
    public ValidationResult<List<CampaignWithSkadNetwork>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithSkadNetwork>, Defect> vr
    ) {
        var isSkadNetworkEnabled = featureService.isEnabledForClientId(
                container.getClientId(), FeatureName.SHOW_SKADNETWORK_ON_NEW_IOS_ENABLED
        );

        return new ListValidationBuilder<>(vr)
                .checkEachBy(e -> validateCampaign(isSkadNetworkEnabled, e), When.isValidAnd(When.isFalse(container.isCopy())))
                .getResult();
    }
}
