package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithSkadNetworkForbidden;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithSkadNetworkForbiddenValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithSkadNetworkForbiddenAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<CampaignWithSkadNetworkForbidden> {

    private final CampaignWithSkadNetworkForbiddenValidator<CampaignWithSkadNetworkForbidden> validator;

    public CampaignWithSkadNetworkForbiddenAddValidationTypeSupport() {
        this.validator = new CampaignWithSkadNetworkForbiddenValidator<>();
    }

    @Override
    public Class<CampaignWithSkadNetworkForbidden> getTypeClass() {
        return CampaignWithSkadNetworkForbidden.class;
    }

    @Override
    public ValidationResult<List<CampaignWithSkadNetworkForbidden>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithSkadNetworkForbidden>, Defect> vr
    ) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(validator, When.isFalse(container.isCopy()))
                .getResult();
    }
}
