package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithTurboApp;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithTurboAppValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class CampaignWithTurboAppAddValidationTypeSupport extends AbstractCampaignAddValidationTypeSupport<CampaignWithTurboApp> {

    private final FeatureService featureService;

    @Autowired
    public CampaignWithTurboAppAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithTurboApp> getTypeClass() {
        return CampaignWithTurboApp.class;
    }

    @Override
    public ValidationResult<List<CampaignWithTurboApp>, Defect> validate(CampaignValidationContainer container,
                                                                         ValidationResult<List<CampaignWithTurboApp>, Defect> vr) {

        boolean canEnableTurboApps = featureService
                .isEnabledForClientId(container.getClientId(), FeatureName.TURBO_APP_ALLOWED);

        var validator = new CampaignWithTurboAppValidator(canEnableTurboApps);

        return new ListValidationBuilder<>(vr).checkEachBy(validator::apply).getResult();
    }
}
