package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithWwManagedOrderFlag;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.CampaignWithWwManagedOrderFlagValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.feature.service.FeatureService;
import ru.yandex.direct.feature.FeatureName;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
public class CampaignWithWwManagedOrderFlagAddValidationTypeSupport  extends AbstractCampaignAddValidationTypeSupport<CampaignWithWwManagedOrderFlag> {
    private final FeatureService featureService;

    @Autowired
    public CampaignWithWwManagedOrderFlagAddValidationTypeSupport(FeatureService featureService) {
        this.featureService = featureService;
    }

    @Override
    public Class<CampaignWithWwManagedOrderFlag> getTypeClass() {
        return CampaignWithWwManagedOrderFlag.class;
    }

    @Override
    public ValidationResult<List<CampaignWithWwManagedOrderFlag>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<CampaignWithWwManagedOrderFlag>, Defect> vr) {
        boolean isWwManagedOrderEnabled = featureService.isEnabledForClientId(container.getClientId(),
                FeatureName.IS_WW_MANAGED_ORDER_AVAILABLE);
        return new ListValidationBuilder<>(vr)
                .checkEachBy(new CampaignWithWwManagedOrderFlagValidator(isWwManagedOrderEnabled))
                .getResult();
    }
}
