package ru.yandex.direct.core.entity.campaign.service.validation.type.add

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.campaign.model.ExternalCampaignWithImpressionRate
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.ExternalCampaignWithImpressionRateValidator
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer
import ru.yandex.direct.validation.builder.ListValidationBuilder
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult

@Component
class ExternalCampaignWithImpressionRateAddValidationTypeSupport :
    AbstractCampaignAddValidationTypeSupport<ExternalCampaignWithImpressionRate>() {

    override fun getTypeClass() = ExternalCampaignWithImpressionRate::class.java

    override fun validate(
        container: CampaignValidationContainer,
        vr: ValidationResult<MutableList<ExternalCampaignWithImpressionRate>, Defect<*>>
    ): ValidationResult<MutableList<ExternalCampaignWithImpressionRate>, Defect<*>> {
        return ListValidationBuilder(vr)
            .checkEachBy(ExternalCampaignWithImpressionRateValidator())
            .result
    }

}