package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalAutobudgetCampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.InternalCampaignWithRotationGoalIdValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@Component
@ParametersAreNonnullByDefault
public class InternalAutobudgetCampaignWithCustomStrategyAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<InternalAutobudgetCampaignWithCustomStrategy> {

    private static final InternalCampaignWithRotationGoalIdValidator<InternalAutobudgetCampaignWithCustomStrategy>
            ROTATION_GOAL_ID_VALIDATOR = new InternalCampaignWithRotationGoalIdValidator<>();

    @Override
    public Class<InternalAutobudgetCampaignWithCustomStrategy> getTypeClass() {
        return InternalAutobudgetCampaignWithCustomStrategy.class;
    }

    @Override
    public ValidationResult<List<InternalAutobudgetCampaignWithCustomStrategy>, Defect> preValidate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalAutobudgetCampaignWithCustomStrategy>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> {
                    var vb = ModelItemValidationBuilder.of(campaign);
                    vb.item(InternalAutobudgetCampaignWithCustomStrategy.ROTATION_GOAL_ID)
                            .check(isNull(), When.isFalse(container.isCopy()));
                    return vb.getResult();
                })
                .getResult();
    }

    @Override
    public ValidationResult<List<InternalAutobudgetCampaignWithCustomStrategy>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalAutobudgetCampaignWithCustomStrategy>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(ROTATION_GOAL_ID_VALIDATOR)
                .getResult();
    }

}
