package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaign;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.InternalCampaignCommonValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.core.entity.internalads.InternalAdValidationUtil;
import ru.yandex.direct.core.entity.internalads.model.InternalAdsOperatorProductAccess;
import ru.yandex.direct.core.entity.internalads.model.InternalAdsProduct;
import ru.yandex.direct.core.entity.internalads.service.InternalAdsOperatorProductAccessService;
import ru.yandex.direct.core.entity.internalads.service.InternalAdsProductService;
import ru.yandex.direct.core.validation.defects.RightsDefects;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CommonConstraints.isEqual;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignAddValidationTypeSupport extends
        AbstractCampaignAddValidationTypeSupport<InternalCampaign> {

    private static final InternalCampaignCommonValidator VALIDATOR = new InternalCampaignCommonValidator();

    private final InternalAdsOperatorProductAccessService internalAdsOperatorProductAccessService;
    private final InternalAdsProductService internalAdsProductService;

    @Autowired
    public InternalCampaignAddValidationTypeSupport(
            InternalAdsOperatorProductAccessService internalAdsOperatorProductAccessService,
            InternalAdsProductService internalAdsProductService) {
        this.internalAdsOperatorProductAccessService = internalAdsOperatorProductAccessService;
        this.internalAdsProductService = internalAdsProductService;
    }

    @Override
    public Class<InternalCampaign> getTypeClass() {
        return InternalCampaign.class;
    }

    @Override
    public ValidationResult<List<InternalCampaign>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalCampaign>, Defect> vr) {
        InternalAdsProduct product = internalAdsProductService.getProduct(container.getClientId());
        boolean isMobileProduct = InternalAdValidationUtil.isMobileProduct(product);

        ListValidationBuilder<InternalCampaign, Defect> lvb = new ListValidationBuilder<>(vr);
        lvb.checkEachBy(campaign -> {
            var vb = ModelItemValidationBuilder.of(campaign);
            vb.item(InternalCampaign.PLACE_ID)
                    .check(notNull())
                    .check(validId(), When.isValid())
                    .check(fromPredicate(
                            placeId -> {
                                InternalAdsOperatorProductAccess access =
                                        internalAdsOperatorProductAccessService.getAccess(container.getOperatorUid(),
                                                container.getClientId());

                                return access.hasWriteAccessToPlace(placeId);
                            }, RightsDefects.noRights()), When.isValid());

            vb.item(InternalCampaign.IS_MOBILE)
                    .check(isEqual(isMobileProduct, CommonDefects.inconsistentState()));

            return vb.getResult();
        })
        .checkEachBy(VALIDATOR);

        return lvb.getResult();
    }
}
