package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.Collections;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithImpressionRate;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.InternalCampaignWithImpressionRateValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignWithImpressionRateAddValidationTypeSupport extends
        AbstractCampaignAddValidationTypeSupport<InternalCampaignWithImpressionRate> {

    @Override
    public Class<InternalCampaignWithImpressionRate> getTypeClass() {
        return InternalCampaignWithImpressionRate.class;
    }

    @Override
    public ValidationResult<List<InternalCampaignWithImpressionRate>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalCampaignWithImpressionRate>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(campaign -> new InternalCampaignWithImpressionRateValidator(
                        campaign.getRfCloseByClick(), Collections.emptyList())
                        .apply(campaign))
                .getResult();
    }

}
