package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRequiredRotationGoalId;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.InternalCampaignWithRequiredRotationGoalIdValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignWithRequiredRotationGoalIdAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<InternalCampaignWithRequiredRotationGoalId> {

    private static final InternalCampaignWithRequiredRotationGoalIdValidator VALIDATOR =
            new InternalCampaignWithRequiredRotationGoalIdValidator();

    @Override
    public Class<InternalCampaignWithRequiredRotationGoalId> getTypeClass() {
        return InternalCampaignWithRequiredRotationGoalId.class;
    }

    @Override
    public ValidationResult<List<InternalCampaignWithRequiredRotationGoalId>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalCampaignWithRequiredRotationGoalId>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(VALIDATOR)
                .getResult();
    }

}
