package ru.yandex.direct.core.entity.campaign.service.validation.type.add;

import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.stereotype.Component;

import ru.yandex.direct.core.entity.campaign.model.InternalCampaignWithRestriction;
import ru.yandex.direct.core.entity.campaign.service.validation.type.bean.InternalCampaignWithRestrictionValidator;
import ru.yandex.direct.core.entity.campaign.service.validation.type.container.CampaignValidationContainer;
import ru.yandex.direct.validation.builder.ListValidationBuilder;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

@Component
@ParametersAreNonnullByDefault
public class InternalCampaignWithRestrictionAddValidationTypeSupport
        extends AbstractCampaignAddValidationTypeSupport<InternalCampaignWithRestriction> {

    private static final InternalCampaignWithRestrictionValidator VALIDATOR =
            new InternalCampaignWithRestrictionValidator();

    @Override
    public Class<InternalCampaignWithRestriction> getTypeClass() {
        return InternalCampaignWithRestriction.class;
    }

    @Override
    public ValidationResult<List<InternalCampaignWithRestriction>, Defect> validate(
            CampaignValidationContainer container,
            ValidationResult<List<InternalCampaignWithRestriction>, Defect> vr) {
        return new ListValidationBuilder<>(vr)
                .checkEachBy(VALIDATOR)
                .getResult();
    }

}
