package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignSupportedOnTouch;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;

@ParametersAreNonnullByDefault
public class CampaignSupportedOnTouchValidator
        implements Validator<CampaignSupportedOnTouch, Defect> {

    private final boolean isTouchDirectEnabled;

    public CampaignSupportedOnTouchValidator(boolean isTouchDirectEnabled) {
        this.isTouchDirectEnabled = isTouchDirectEnabled;
    }

    @Override
    public ValidationResult<CampaignSupportedOnTouch, Defect> apply(CampaignSupportedOnTouch campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignSupportedOnTouch.IS_TOUCH)
                .check(notNull(), When.isTrue(isTouchDirectEnabled))
                .check(notTrue(), When.isFalse(isTouchDirectEnabled));
        return vb.getResult();
    }

}
