package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataBusinessCategory;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstraints.charsAreAllowed;
import static ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstraints.stringIsNotBlank;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_BUSINESS_CATEGORY_LENGTH;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

public class CampaignWithAdditionalDataBusinessCategoryValidator implements Validator<CampaignWithAdditionalDataBusinessCategory, Defect> {

    @Override
    public ValidationResult<CampaignWithAdditionalDataBusinessCategory, Defect> apply(CampaignWithAdditionalDataBusinessCategory campaign) {
        ModelItemValidationBuilder<CampaignWithAdditionalDataBusinessCategory> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAdditionalDataBusinessCategory.BUSINESS_CATEGORY)
                .checkBy(getBusinessCategoryValidator(), When.notNull());
        return vb.getResult();
    }

    private static Validator<String, Defect> getBusinessCategoryValidator() {
        return name -> {
            ItemValidationBuilder<String, Defect> vb = ItemValidationBuilder.of(name);
            vb
                    .check(stringIsNotBlank())
                    .check(charsAreAllowed())
                    .check(maxStringLength(MAX_BUSINESS_CATEGORY_LENGTH));
            return vb.getResult();
        };
    }
}
