package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataCompanyName;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstraints.charsAreAllowed;
import static ru.yandex.direct.core.entity.banner.service.validation.BannerTextConstraints.stringIsNotBlank;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_COMPANY_NAME_LENGTH;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

public class CampaignWithAdditionalDataCompanyNameValidator implements Validator<CampaignWithAdditionalDataCompanyName, Defect> {

    @Override
    public ValidationResult<CampaignWithAdditionalDataCompanyName, Defect> apply(CampaignWithAdditionalDataCompanyName campaign) {
        ModelItemValidationBuilder<CampaignWithAdditionalDataCompanyName> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAdditionalDataCompanyName.COMPANY_NAME).checkBy(getCompanyNameValidator(), When.notNull());
        return vb.getResult();
    }

    private static Validator<String, Defect> getCompanyNameValidator() {
        return name -> {
            ItemValidationBuilder<String, Defect> vb = ItemValidationBuilder.of(name);
            vb
                    .check(stringIsNotBlank())
                    .check(charsAreAllowed())
                    .check(maxStringLength(MAX_COMPANY_NAME_LENGTH));
            return vb.getResult();
        };
    }
}
