package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.banner.type.href.BannerHrefValidator;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdditionalDataHref;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

public class CampaignWithAdditionalDataHrefValidator implements Validator<CampaignWithAdditionalDataHref, Defect> {

    @Override
    public ValidationResult<CampaignWithAdditionalDataHref, Defect> apply(CampaignWithAdditionalDataHref campaign) {
        ModelItemValidationBuilder<CampaignWithAdditionalDataHref> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAdditionalDataHref.HREF).checkBy(new BannerHrefValidator(), When.notNull());
        return vb.getResult();
    }
}
