package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdvancedGeoTargeting;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.ItemValidationBuilder;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;

import static ru.yandex.direct.validation.defect.CommonDefects.invalidValue;

public class CampaignWithAdvancedGeoTargetingUpdatePreValidator
        implements Validator<ModelChanges<CampaignWithAdvancedGeoTargeting>, Defect> {

    @Override
    public ValidationResult<ModelChanges<CampaignWithAdvancedGeoTargeting>, Defect> apply(
            ModelChanges<CampaignWithAdvancedGeoTargeting> campaign) {
        ItemValidationBuilder<ModelChanges<CampaignWithAdvancedGeoTargeting>, Defect> vb =
                ItemValidationBuilder.of(campaign);

        vb.check(checkCorrectChange());

        return vb.getResult();
    }

    public Constraint<ModelChanges<CampaignWithAdvancedGeoTargeting>, Defect> checkCorrectChange() {
        return Constraint.fromPredicate(c -> {
            var useCurrentRegion = c.getPropIfChanged(CampaignWithAdvancedGeoTargeting.USE_CURRENT_REGION);
            var useRegularRegion = c.getPropIfChanged(CampaignWithAdvancedGeoTargeting.USE_REGULAR_REGION);
            return !(Boolean.FALSE.equals(useCurrentRegion) && Boolean.FALSE.equals(useRegularRegion));
        }, invalidValue());
    }

}
