package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAdvancedGeoTargeting;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

@ParametersAreNonnullByDefault
public class CampaignWithAdvancedGeoTargetingValidator
        implements Validator<CampaignWithAdvancedGeoTargeting, Defect> {

    private boolean advancedGeoTargeting;

    public CampaignWithAdvancedGeoTargetingValidator(boolean advancedGeoTargeting) {
        this.advancedGeoTargeting = advancedGeoTargeting;
    }

    @Override
    public ValidationResult<CampaignWithAdvancedGeoTargeting, Defect> apply(CampaignWithAdvancedGeoTargeting campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAdvancedGeoTargeting.HAS_EXTENDED_GEO_TARGETING)
                .check(notNull());
        vb.item(CampaignWithAdvancedGeoTargeting.USE_CURRENT_REGION)
                .check(notNull(), When.isTrue(advancedGeoTargeting))
                .check(isNullOrFalse(), When.isFalse(advancedGeoTargeting));
        vb.item(CampaignWithAdvancedGeoTargeting.USE_REGULAR_REGION)
                .check(notNull(), When.isTrue(advancedGeoTargeting))
                .check(isNullOrFalse(), When.isFalse(advancedGeoTargeting));

        vb.check(checkCorrect(), When.isValidAnd(When.isTrue(advancedGeoTargeting)));

        return vb.getResult();
    }

    @NotNull
    private Constraint<CampaignWithAdvancedGeoTargeting, Defect> checkCorrect() {
        return Constraint.fromPredicate(
                c -> {
                    var useCurrentRegion = c.getUseCurrentRegion();
                    var useRegularRegion = c.getUseRegularRegion();
                    return !(Boolean.FALSE.equals(useCurrentRegion) && Boolean.FALSE.equals(useRegularRegion));
                },
                CommonDefects.invalidValue()
        );
    }

    private Constraint<Boolean, Defect> isNullOrFalse() {
        return Constraint.fromPredicateOfNullable(flag -> !Boolean.TRUE.equals(flag), CommonDefects.isNull());
    }
}
