package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContentForbidden;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@ParametersAreNonnullByDefault
public class CampaignWithAllowedOnAdultContentForbiddenValidator
        implements Validator<CampaignWithAllowedOnAdultContentForbidden, Defect> {

    @Override
    public ValidationResult<CampaignWithAllowedOnAdultContentForbidden, Defect> apply(
            CampaignWithAllowedOnAdultContentForbidden campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAllowedOnAdultContentForbidden.IS_ALLOWED_ON_ADULT_CONTENT)
                .check(isNull());
        return vb.getResult();
    }
}
