package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedOnAdultContent;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notTrue;

@ParametersAreNonnullByDefault
public class CampaignWithAllowedOnAdultContentValidator implements Validator<CampaignWithAllowedOnAdultContent, Defect> {
    private final boolean isAllowedOnAdultContentEnabled;

    public CampaignWithAllowedOnAdultContentValidator(boolean isAllowedOnAdultContentEnabled) {
        this.isAllowedOnAdultContentEnabled = isAllowedOnAdultContentEnabled;
    }

    @Override
    public ValidationResult<CampaignWithAllowedOnAdultContent, Defect> apply(CampaignWithAllowedOnAdultContent campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAllowedOnAdultContent.IS_ALLOWED_ON_ADULT_CONTENT)
                .check(notTrue(), When.isFalse(isAllowedOnAdultContentEnabled));
        return vb.getResult();
    }
}
