package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Set;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAllowedPageIds;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants;
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_DOMAIN_LENGTH;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.isValidDomain;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.isValidSsp;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

public class CampaignWithAllowedPageIdsValidator implements Validator<CampaignWithAllowedPageIds, Defect> {
    private final Set<String> knownSsp;

    public CampaignWithAllowedPageIdsValidator(SspPlatformsRepository sspPlatformsRepository) {
        knownSsp = Set.copyOf(sspPlatformsRepository.getAllSspPlatforms());
    }

    @Override
    public ValidationResult<CampaignWithAllowedPageIds, Defect> apply(CampaignWithAllowedPageIds campaign) {
        ModelItemValidationBuilder<CampaignWithAllowedPageIds> vb = ModelItemValidationBuilder.of(campaign);
        vb.list(CampaignWithAllowedPageIds.ALLOWED_PAGE_IDS)
                .check(maxListSize(CampaignConstants.MAX_ALLOWED_PAGE_IDS_COUNT))
                .checkEach(validId());

        vb.list(CampaignWithAllowedPageIds.ALLOWED_DOMAINS)
                .checkEach(maxStringLength(MAX_DOMAIN_LENGTH))
                .checkEach(isValidDomain());

        vb.list(CampaignWithAllowedPageIds.ALLOWED_SSP)
                .checkEach(isValidSsp(knownSsp));

        return vb.getResult();
    }
}
