package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithAloneTrafaretForbidden;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@ParametersAreNonnullByDefault
public class CampaignWithAloneTrafaretForbiddenValidator
        implements Validator<CampaignWithAloneTrafaretForbidden, Defect> {
    @Override
    public ValidationResult<CampaignWithAloneTrafaretForbidden, Defect> apply(
            CampaignWithAloneTrafaretForbidden campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAloneTrafaretForbidden.IS_ALONE_TRAFARET_ALLOWED)
                .check(isNull());
        return vb.getResult();
    }
}
