package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Set;

import ru.yandex.direct.core.entity.campaign.model.CampaignAttributionModel;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithAttributionModel;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.constraint.CommonConstraints;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.notAllowedAttributionType;
import static ru.yandex.direct.feature.FeatureName.CROSS_DEVICE_ATTRIBUTION_TYPES;

public class CampaignWithAttributionModelValidator implements Validator<CampaignWithAttributionModel, Defect> {

    private final Set<String> availableFeatures;

    public CampaignWithAttributionModelValidator(Set<String> availableFeatures) {
        this.availableFeatures = availableFeatures;
    }

    @Override
    public ValidationResult<CampaignWithAttributionModel, Defect> apply(CampaignWithAttributionModel campaign) {
        ModelItemValidationBuilder<CampaignWithAttributionModel> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithAttributionModel.ATTRIBUTION_MODEL)
                .check(CommonConstraints.notNull())
                .checkBy(this::validateCrossDeviceAttributionTypes);
        return vb.getResult();
    }

    private ValidationResult<CampaignAttributionModel, Defect> validateCrossDeviceAttributionTypes(CampaignAttributionModel attributionModel) {
        boolean crossDeviceAttributionTypesEnabled =
                availableFeatures.contains(CROSS_DEVICE_ATTRIBUTION_TYPES.getName());

        if (!crossDeviceAttributionTypesEnabled && isCrossDevice(attributionModel)) {
            return ValidationResult.failed(attributionModel, notAllowedAttributionType());
        }

        return new ValidationResult<>(attributionModel);
    }

    private boolean isCrossDevice(CampaignAttributionModel attributionModel) {
        return attributionModel == CampaignAttributionModel.FIRST_CLICK_CROSS_DEVICE
                || attributionModel == CampaignAttributionModel.LAST_SIGNIFICANT_CLICK_CROSS_DEVICE
                || attributionModel == CampaignAttributionModel.LAST_YANDEX_DIRECT_CLICK_CROSS_DEVICE;
    }
}
