package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBannerHrefParams;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.hrefparams.validation.HrefParamsConstraints.hrefParamsHaveValidLength;
import static ru.yandex.direct.core.entity.hrefparams.validation.HrefParamsConstraints.hrefWithParamsValid;

public class CampaignWithBannerHrefParamsValidator implements Validator<CampaignWithBannerHrefParams, Defect> {

    public CampaignWithBannerHrefParamsValidator() {
    }

    @Override
    public ValidationResult<CampaignWithBannerHrefParams, Defect> apply(CampaignWithBannerHrefParams campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        if (campaign.getBannerHrefParams() != null) {
            vb.item(CampaignWithBannerHrefParams.BANNER_HREF_PARAMS)
                    .check(hrefParamsHaveValidLength())
                    .check(hrefWithParamsValid(), When.isValid());
        }

        return vb.getResult();
    }
}
