package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandLiftHiddenForbidden;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.isNull;

@ParametersAreNonnullByDefault
public class CampaignWithBrandLiftHiddenForbiddenValidator
        implements Validator<CampaignWithBrandLiftHiddenForbidden, Defect> {

    @Override
    public ValidationResult<CampaignWithBrandLiftHiddenForbidden, Defect> apply(
            CampaignWithBrandLiftHiddenForbidden campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithBrandLiftHiddenForbidden.IS_BRAND_LIFT_HIDDEN)
                .check(isNull());
        return vb.getResult();
    }
}
