package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Set;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithBrandSafety;
import ru.yandex.direct.core.entity.retargeting.model.Goal;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.defect.CommonDefects;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.crypta.utils.CryptaSegmentBrandSafetyUtils.checkIfBrandSafetyCategoryIsAvailableForClient;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.unique;
import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;
import static ru.yandex.direct.validation.constraint.NumberConstraints.inRange;

public class CampaignWithBrandSafetyValidator implements Validator<CampaignWithBrandSafety, Defect> {
    private final Set<String> clientFeatures;

    public CampaignWithBrandSafetyValidator(Set<String> clientFeatures) {
        this.clientFeatures = clientFeatures;
    }

    @Override
    public ValidationResult<CampaignWithBrandSafety, Defect> apply(CampaignWithBrandSafety campaign) {
        ModelItemValidationBuilder<CampaignWithBrandSafety> vb = ModelItemValidationBuilder.of(campaign);
        vb.list(CampaignWithBrandSafety.BRAND_SAFETY_CATEGORIES)
                .checkEach(notNull(), When.isValid())
                .checkEach(unique(), When.isValid())
                .checkEach(inRange(Goal.BRANDSAFETY_LOWER_BOUND, Goal.BRANDSAFETY_UPPER_BOUND - 1))
                .checkEach(fromPredicate(categoryId -> checkIfBrandSafetyCategoryIsAvailableForClient(
                         categoryId, clientFeatures), CommonDefects.invalidValue()));
        return vb.getResult();
    }
}
