package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.BroadMatch;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithBroadMatch;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.relevantKeywordsUselessForChosenStrategy;
import static ru.yandex.direct.validation.builder.Constraint.fromPredicate;

@ParametersAreNonnullByDefault
public class CampaignWithBroadMatchPreValidator implements Validator<CampaignWithBroadMatch, Defect> {

    public CampaignWithBroadMatchPreValidator() {
    }

    @Override
    public ValidationResult<CampaignWithBroadMatch, Defect> apply(CampaignWithBroadMatch campaign) {

        var vb = ModelItemValidationBuilder.of(campaign);

        BroadMatch broadMatch = campaign.getBroadMatch();
        DbStrategy strategy = campaign.getStrategy();
        if (broadMatch == null || strategy == null) {
            return vb.getResult();
        }

        vb.modelItem(CampaignWithBroadMatch.BROAD_MATCH)
                .item(BroadMatch.BROAD_MATCH_FLAG)
                .weakCheck(fromPredicate(broadMatchFlag -> !(broadMatchFlag && strategy.isSearchStop()),
                        relevantKeywordsUselessForChosenStrategy()));

        return vb.getResult();
    }
}
