package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithContactInfo;
import ru.yandex.direct.core.entity.vcard.service.validation.MetroIdValidator;
import ru.yandex.direct.core.entity.vcard.service.validation.VcardValidator;
import ru.yandex.direct.model.AppliedChanges;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.builder.When;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

@ParametersAreNonnullByDefault
public class CampaignWithContactInfoValidator implements Validator<CampaignWithContactInfo, Defect> {

    private final MetroIdValidator metroIdValidator;
    private final AppliedChanges<CampaignWithContactInfo> appliedChanges;

    private CampaignWithContactInfoValidator(
            MetroIdValidator metroIdValidator,
            @Nullable AppliedChanges<CampaignWithContactInfo> appliedChanges) {
        this.metroIdValidator = metroIdValidator;
        this.appliedChanges = appliedChanges;
    }

    public static CampaignWithContactInfoValidator build(
            MetroIdValidator metroIdValidator,
            @Nullable AppliedChanges<CampaignWithContactInfo> appliedChanges) {
        return new CampaignWithContactInfoValidator(metroIdValidator, appliedChanges);
    }

    @Override
    public ValidationResult<CampaignWithContactInfo, Defect> apply(CampaignWithContactInfo campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        if (appliedChanges == null || appliedChanges.passed(CampaignWithContactInfo.CONTACT_INFO)) {
            vb.item(CampaignWithContactInfo.CONTACT_INFO)
                    .checkBy(vcard -> VcardValidator.build(metroIdValidator).apply(vcard), When.notNull());
        }

        return vb.getResult();
    }
}
