package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.math.BigDecimal;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomStrategyAndCustomDayBudget;
import ru.yandex.direct.core.entity.campaign.model.DbStrategy;
import ru.yandex.direct.validation.builder.Constraint;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.CampaignStrategyUtils.strategySupportsDayBudget;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignDefects.dayBudgetNotSupportedWithStrategy;
import static ru.yandex.direct.utils.NumberUtils.isZero;

public class CampaignWithCustomStrategyAndCustomDayBudgetValidator implements Validator<CampaignWithCustomStrategyAndCustomDayBudget, Defect> {
    @Override
    public ValidationResult<CampaignWithCustomStrategyAndCustomDayBudget, Defect> apply(
            CampaignWithCustomStrategyAndCustomDayBudget campaignWithStrategyAndDayBudget) {
        ModelItemValidationBuilder<CampaignWithCustomStrategyAndCustomDayBudget> vb =
                ModelItemValidationBuilder.of(campaignWithStrategyAndDayBudget);
        vb.item(CampaignWithCustomStrategyAndCustomDayBudget.DAY_BUDGET)
                .check(validateDayBudgetWithStrategy(campaignWithStrategyAndDayBudget.getStrategy()));
        return vb.getResult();
    }

    private Constraint<BigDecimal, Defect> validateDayBudgetWithStrategy(DbStrategy strategy) {
        return Constraint.fromPredicate(dayBudget -> isZero(dayBudget)
                || strategySupportsDayBudget(strategy), dayBudgetNotSupportedWithStrategy());
    }

}
