package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Collection;
import java.util.Set;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDialog;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.inSet;

public class CampaignWithDialogValidator implements Validator<CampaignWithDialog, Defect> {
    private final Set<Long> availableDialogIds;

    public CampaignWithDialogValidator(Collection<Long> availableDialogIds) {
        this.availableDialogIds = Set.copyOf(availableDialogIds);
    }

    @Override
    public ValidationResult<CampaignWithDialog, Defect> apply(CampaignWithDialog campaign) {
        ModelItemValidationBuilder<CampaignWithDialog> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithDialog.CLIENT_DIALOG_ID).check(inSet(availableDialogIds));
        return vb.getResult();
    }
}
