package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledDomainsAndSsp;
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService;
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_DOMAIN_LENGTH;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.isValidDisabledDomain;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.isValidSsp;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.totalDisabledPlacesMaxSize;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.uniquePlaces;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

@ParametersAreNonnullByDefault
public class CampaignWithDisabledDomainsAndSspValidator implements
        Validator<CampaignWithDisabledDomainsAndSsp, Defect> {

    private final Set<String> knownSsp;
    private final ClientId clientId;
    private final int generalBlacklistSizeLimit;
    private final DisableDomainValidationService disableDomainValidationService;

    public CampaignWithDisabledDomainsAndSspValidator(SspPlatformsRepository sspPlatformsRepository,
                                                      ClientId clientId, int generalBlacklistSizeLimit,
                                                      DisableDomainValidationService disableDomainValidationService) {
        knownSsp = Set.copyOf(sspPlatformsRepository.getAllSspPlatforms());
        this.clientId = clientId;
        this.generalBlacklistSizeLimit = generalBlacklistSizeLimit;
        this.disableDomainValidationService = disableDomainValidationService;
    }

    @Override
    public ValidationResult<CampaignWithDisabledDomainsAndSsp, Defect> apply(
            CampaignWithDisabledDomainsAndSsp campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);
        vb.check(totalDisabledPlacesMaxSize(generalBlacklistSizeLimit));
        vb.check(uniquePlaces());

        vb.list(CampaignWithDisabledDomainsAndSsp.DISABLED_DOMAINS)
                .checkEach(maxStringLength(MAX_DOMAIN_LENGTH))
                .checkEach(isValidDisabledDomain(clientId, disableDomainValidationService));

        vb.list(CampaignWithDisabledDomainsAndSsp.DISABLED_SSP)
                .checkEach(isValidSsp(knownSsp));

        return vb.getResult();
    }
}
