package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisabledVideoPlacements;
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.MAX_DOMAIN_LENGTH;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.isValidDisabledDomain;
import static ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstraints.uniqueStrings;
import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength;

@ParametersAreNonnullByDefault
public class CampaignWithDisabledVideoPlacementsValidator implements
        Validator<CampaignWithDisabledVideoPlacements, Defect> {

    private final Integer videoBlacklistSizeLimit;
    private final ClientId clientId;
    private final DisableDomainValidationService disableDomainValidationService;

    public CampaignWithDisabledVideoPlacementsValidator(Integer videoBlacklistSizeLimit,
                                                        ClientId clientId, DisableDomainValidationService disableDomainValidationService) {
        this.videoBlacklistSizeLimit = videoBlacklistSizeLimit;
        this.clientId = clientId;
        this.disableDomainValidationService = disableDomainValidationService;
    }

    @Override
    public ValidationResult<CampaignWithDisabledVideoPlacements, Defect> apply(
            CampaignWithDisabledVideoPlacements campaign) {
        var vb = ModelItemValidationBuilder.of(campaign);

        vb.list(CampaignWithDisabledVideoPlacements.DISABLED_VIDEO_PLACEMENTS)
                .check(maxListSize(videoBlacklistSizeLimit))
                .check(uniqueStrings())
                .checkEach(maxStringLength(MAX_DOMAIN_LENGTH))
                .checkEach(isValidDisabledDomain(clientId, disableDomainValidationService));

        return vb.getResult();
    }

}
