package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithDisallowedPageIds;
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize;
import static ru.yandex.direct.validation.constraint.CommonConstraints.validId;

public class CampaignWithDisallowedPageIdsValidator implements Validator<CampaignWithDisallowedPageIds, Defect> {

    public CampaignWithDisallowedPageIdsValidator() {
    }

    @Override
    public ValidationResult<CampaignWithDisallowedPageIds, Defect> apply(CampaignWithDisallowedPageIds campaign) {
        ModelItemValidationBuilder<CampaignWithDisallowedPageIds> vb = ModelItemValidationBuilder.of(campaign);
        vb.list(CampaignWithDisallowedPageIds.DISALLOWED_PAGE_IDS)
                .check(maxListSize(CampaignConstants.MAX_ALLOWED_PAGE_IDS_COUNT))
                .checkEach(validId());

        return vb.getResult();
    }
}
