package ru.yandex.direct.core.entity.campaign.service.validation.type.bean;

import ru.yandex.direct.core.entity.campaign.model.CampaignWithEnableCompanyInfo;
import ru.yandex.direct.validation.builder.Validator;
import ru.yandex.direct.validation.result.Defect;
import ru.yandex.direct.validation.result.ValidationResult;
import ru.yandex.direct.validation.wrapper.ModelItemValidationBuilder;

import static ru.yandex.direct.validation.constraint.CommonConstraints.notNull;

public class CampaignWithEnableCompanyInfoValidator implements Validator<CampaignWithEnableCompanyInfo, Defect> {

    @Override
    public ValidationResult<CampaignWithEnableCompanyInfo, Defect> apply(CampaignWithEnableCompanyInfo campaign) {
        ModelItemValidationBuilder<CampaignWithEnableCompanyInfo> vb = ModelItemValidationBuilder.of(campaign);
        vb.item(CampaignWithEnableCompanyInfo.ENABLE_COMPANY_INFO)
                .check(notNull());
        return vb.getResult();
    }

}
